/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockModelDefinition;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.ConduitTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelBakery {
    public static final RenderMaterial field_207763_a = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_0"));
    public static final RenderMaterial field_207764_b = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/fire_1"));
    public static final RenderMaterial field_207766_d = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/lava_flow"));
    public static final RenderMaterial field_207768_f = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/water_flow"));
    public static final RenderMaterial field_207769_g = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("block/water_overlay"));
    public static final RenderMaterial field_229315_f_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/banner_base"));
    public static final RenderMaterial field_229316_g_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base"));
    public static final RenderMaterial field_229317_h_ = new RenderMaterial(AtlasTexture.field_110575_b, new ResourceLocation("entity/shield_base_nopattern"));
    public static final List<ResourceLocation> field_229318_i_ = IntStream.range(0, 10).mapToObj(n -> new ResourceLocation("block/destroy_stage_" + n)).collect(Collectors.toList());
    public static final List<ResourceLocation> field_229319_j_ = field_229318_i_.stream().map(resourceLocation -> new ResourceLocation("textures/" + resourceLocation.func_110623_a() + ".png")).collect(Collectors.toList());
    public static final List<RenderType> field_229320_k_ = field_229319_j_.stream().map(RenderType::func_228656_k_).collect(Collectors.toList());
    private static final Set<RenderMaterial> field_177602_b = Util.func_200696_a(Sets.newHashSet(), hashSet2 -> {
        HashSet hashSet2;
        hashSet2.add(field_207768_f);
        hashSet2.add(field_207766_d);
        hashSet2.add(field_207769_g);
        hashSet2.add(field_207763_a);
        hashSet2.add(field_207764_b);
        hashSet2.add(BellTileEntityRenderer.field_217653_c);
        hashSet2.add(ConduitTileEntityRenderer.field_205118_a);
        hashSet2.add(ConduitTileEntityRenderer.field_205119_d);
        hashSet2.add(ConduitTileEntityRenderer.field_205120_e);
        hashSet2.add(ConduitTileEntityRenderer.field_205121_f);
        hashSet2.add(ConduitTileEntityRenderer.field_207746_g);
        hashSet2.add(ConduitTileEntityRenderer.field_207747_h);
        hashSet2.add(EnchantmentTableTileEntityRenderer.field_147540_b);
        hashSet2.add(field_229315_f_);
        hashSet2.add(field_229316_g_);
        hashSet2.add(field_229317_h_);
        for (ResourceLocation resourceLocation : field_229318_i_) {
            hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, resourceLocation));
        }
        hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226616_d_));
        hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226617_e_));
        hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226618_f_));
        hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226619_g_));
        hashSet2.add(new RenderMaterial(AtlasTexture.field_110575_b, PlayerContainer.field_226620_h_));
        Atlases.func_228775_a_(hashSet2::add);
    });
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    private static final String field_229321_r_ = field_177604_a.toString();
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195675_b().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    public static final BlockModel field_177606_o = Util.func_200696_a(BlockModel.func_178294_a("{\"gui_light\": \"front\"}"), blockModel -> {
        blockModel.field_178317_b = "generation marker";
    });
    public static final BlockModel field_177616_r = Util.func_200696_a(BlockModel.func_178294_a("{\"gui_light\": \"side\"}"), blockModel -> {
        blockModel.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, BlockState> field_209613_y = new StateContainer.Builder(Blocks.field_150350_a).func_206894_a(BooleanProperty.func_177716_a("map")).func_235882_a_(Block::func_176223_P, BlockState::new);
    private static final ItemModelGenerator field_217854_z = new ItemModelGenerator();
    private static final Map<ResourceLocation, StateContainer<Block, BlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), field_209613_y);
    private final IResourceManager field_177598_f;
    @Nullable
    private SpriteMap field_229322_z_;
    private final BlockColors field_225365_D;
    private final Set<ResourceLocation> field_217848_D = Sets.newHashSet();
    private final BlockModelDefinition.ContainerHolder field_209610_F = new BlockModelDefinition.ContainerHolder();
    private final Map<ResourceLocation, IUnbakedModel> field_217849_F = Maps.newHashMap();
    private final Map<Triple<ResourceLocation, TransformationMatrix, Boolean>, IBakedModel> field_217850_G = Maps.newHashMap();
    private final Map<ResourceLocation, IUnbakedModel> field_217851_H = Maps.newHashMap();
    private final Map<ResourceLocation, IBakedModel> field_217852_I = Maps.newHashMap();
    private final Map<ResourceLocation, Pair<AtlasTexture, AtlasTexture.SheetData>> field_217853_J;
    private int field_225366_L = 1;
    private final Object2IntMap<BlockState> field_225367_M = (Object2IntMap)Util.func_200696_a(new Object2IntOpenHashMap(), object2IntOpenHashMap -> object2IntOpenHashMap.defaultReturnValue(-1));

    public ModelBakery(IResourceManager iResourceManager, BlockColors blockColors, IProfiler iProfiler2, int n) {
        this.field_177598_f = iResourceManager;
        this.field_225365_D = blockColors;
        iProfiler2.func_76320_a("missing_model");
        try {
            this.field_217849_F.put(field_177604_a, this.func_177594_c(field_177604_a));
            this.func_217843_a(field_177604_a);
        }
        catch (IOException \u26032) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)\u26032);
            throw new RuntimeException(\u26032);
        }
        iProfiler2.func_219895_b("static_definitions");
        field_209607_C.forEach((resourceLocation, stateContainer) -> stateContainer.func_177619_a().forEach(blockState -> this.func_217843_a(BlockModelShapes.func_209553_a(resourceLocation, blockState))));
        iProfiler2.func_219895_b("blocks");
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(blockState -> this.func_217843_a(BlockModelShapes.func_209554_c(blockState)));
        }
        iProfiler2.func_219895_b("items");
        for (ResourceLocation resourceLocation2 : Registry.field_212630_s.func_148742_b()) {
            this.func_217843_a(new ModelResourceLocation(resourceLocation2, "inventory"));
        }
        iProfiler2.func_219895_b("special");
        this.func_217843_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        iProfiler2.func_219895_b("textures");
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        Set set = this.field_217851_H.values().stream().flatMap(iUnbakedModel -> iUnbakedModel.func_225614_a_(this::func_209597_a, \u26032).stream()).collect(Collectors.toSet());
        set.addAll(field_177602_b);
        linkedHashSet.stream().filter(pair -> !((String)pair.getSecond()).equals(field_229321_r_)).forEach(pair -> field_177603_c.warn("Unable to resolve texture reference: {} in {}", pair.getFirst(), pair.getSecond()));
        Map<ResourceLocation, List<RenderMaterial>> \u26034 = set.stream().collect(Collectors.groupingBy(RenderMaterial::func_229310_a_));
        iProfiler2.func_219895_b("stitching");
        this.field_217853_J = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, List<RenderMaterial>> entry : \u26034.entrySet()) {
            AtlasTexture atlasTexture = new AtlasTexture(entry.getKey());
            AtlasTexture.SheetData \u26035 = atlasTexture.func_229220_a_(this.field_177598_f, entry.getValue().stream().map(RenderMaterial::func_229313_b_), iProfiler2, n);
            this.field_217853_J.put(entry.getKey(), (Pair<AtlasTexture, AtlasTexture.SheetData>)Pair.of((Object)atlasTexture, (Object)\u26035));
        }
        iProfiler2.func_76319_b();
    }

    public SpriteMap func_229333_a_(TextureManager textureManager, IProfiler iProfiler) {
        iProfiler.func_76320_a("atlas");
        for (Pair<AtlasTexture, AtlasTexture.SheetData> pair : this.field_217853_J.values()) {
            AtlasTexture atlasTexture = (AtlasTexture)pair.getFirst();
            AtlasTexture.SheetData \u26032 = (AtlasTexture.SheetData)pair.getSecond();
            atlasTexture.func_215260_a(\u26032);
            textureManager.func_229263_a_(atlasTexture.func_229223_g_(), atlasTexture);
            textureManager.func_110577_a(atlasTexture.func_229223_g_());
            atlasTexture.func_229221_b_(\u26032);
        }
        this.field_229322_z_ = new SpriteMap(this.field_217853_J.values().stream().map(Pair::getFirst).collect(Collectors.toList()));
        iProfiler.func_219895_b("baking");
        this.field_217851_H.keySet().forEach(resourceLocation -> {
            IBakedModel iBakedModel = null;
            try {
                iBakedModel = this.func_217845_a((ResourceLocation)resourceLocation, ModelRotation.X0_Y0);
            }
            catch (Exception \u26032) {
                field_177603_c.warn("Unable to bake model: '{}': {}", resourceLocation, (Object)\u26032);
            }
            if (iBakedModel != null) {
                this.field_217852_I.put((ResourceLocation)resourceLocation, iBakedModel);
            }
        });
        iProfiler.func_76319_b();
        return this.field_229322_z_;
    }

    private static Predicate<BlockState> func_209605_a(StateContainer<Block, BlockState> stateContainer, String string) {
        HashMap hashMap = Maps.newHashMap();
        for (String string2 : field_209611_w.split((CharSequence)string)) {
            Iterator iterator = field_209612_x.split((CharSequence)string2).iterator();
            if (!iterator.hasNext()) continue;
            String \u26032 = (String)iterator.next();
            Property<?> \u26033 = stateContainer.func_185920_a(\u26032);
            if (\u26033 != null && iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Object \u26034 = ModelBakery.func_209592_a(\u26033, string3);
                if (\u26034 != null) {
                    hashMap.put(\u26033, \u26034);
                    continue;
                }
                throw new RuntimeException("Unknown value: '" + string3 + "' for blockstate property: '" + \u26032 + "' " + \u26033.func_177700_c());
            }
            if (\u26032.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + \u26032 + "'");
        }
        Block block = stateContainer.func_177622_c();
        return blockState -> {
            if (blockState == null || block != blockState.func_177230_c()) {
                return false;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (Objects.equals(blockState.func_177229_b((Property)entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(Property<T> property, String string) {
        return (T)((Comparable)property.func_185929_b(string).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation resourceLocation) {
        if (this.field_217849_F.containsKey(resourceLocation)) {
            return this.field_217849_F.get(resourceLocation);
        }
        if (this.field_217848_D.contains(resourceLocation)) {
            throw new IllegalStateException("Circular reference while loading " + resourceLocation);
        }
        this.field_217848_D.add(resourceLocation);
        IUnbakedModel iUnbakedModel = this.field_217849_F.get(field_177604_a);
        while (!this.field_217848_D.isEmpty()) {
            ResourceLocation resourceLocation2 = this.field_217848_D.iterator().next();
            try {
                if (this.field_217849_F.containsKey(resourceLocation2)) continue;
                this.func_209598_b(resourceLocation2);
            }
            catch (BlockStateDefinitionException \u26032) {
                field_177603_c.warn(\u26032.getMessage());
                this.field_217849_F.put(resourceLocation2, iUnbakedModel);
            }
            catch (Exception \u26033) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourceLocation2, (Object)resourceLocation, (Object)\u26033);
                this.field_217849_F.put(resourceLocation2, iUnbakedModel);
            }
            finally {
                this.field_217848_D.remove(resourceLocation2);
            }
        }
        return this.field_217849_F.getOrDefault(resourceLocation, iUnbakedModel);
    }

    private void func_209598_b(ResourceLocation resourceLocation) throws Exception {
        if (!(resourceLocation instanceof ModelResourceLocation)) {
            this.func_209593_a(resourceLocation, this.func_177594_c(resourceLocation));
            return;
        }
        ModelResourceLocation modelResourceLocation2 = (ModelResourceLocation)resourceLocation;
        if (Objects.equals(modelResourceLocation2.func_177518_c(), "inventory")) {
            ResourceLocation resourceLocation2 = new ResourceLocation(resourceLocation.func_110624_b(), "item/" + resourceLocation.func_110623_a());
            BlockModel \u26032 = this.func_177594_c(resourceLocation2);
            this.func_209593_a(modelResourceLocation2, \u26032);
            this.field_217849_F.put(resourceLocation2, \u26032);
        } else {
            \u2603 = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
            StateContainer \u26033 = Optional.ofNullable(field_209607_C.get(\u2603)).orElseGet(() -> Registry.field_212618_g.func_82594_a(\u2603).func_176194_O());
            this.field_209610_F.func_209573_a(\u26033);
            ImmutableList \u26034 = ImmutableList.copyOf(this.field_225365_D.func_225310_a((Block)\u26033.func_177622_c()));
            ImmutableList \u26035 = \u26033.func_177619_a();
            HashMap \u26036 = Maps.newHashMap();
            \u26035.forEach(blockState -> \u26036.put(BlockModelShapes.func_209553_a(\u2603, blockState), blockState));
            HashMap \u26037 = Maps.newHashMap();
            \u2603 = new ResourceLocation(resourceLocation.func_110624_b(), "blockstates/" + resourceLocation.func_110623_a() + ".json");
            IUnbakedModel \u26038 = this.field_217849_F.get(field_177604_a);
            ModelListWrapper \u26039 = new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)\u26038), (List<Object>)ImmutableList.of());
            Pair \u260310 = Pair.of((Object)\u26038, () -> \u26039);
            try {
                List list;
                try {
                    list = this.field_177598_f.func_199004_b(\u2603).stream().map(iResource -> {
                        try (InputStream inputStream = iResource.func_199027_b();){
                            Pair pair = Pair.of((Object)iResource.func_199026_d(), (Object)BlockModelDefinition.func_209577_a(this.field_209610_F, new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                            return pair;
                        }
                        catch (Exception exception) {
                            throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", iResource.func_199029_a(), iResource.func_199026_d(), exception.getMessage()));
                        }
                    }).collect(Collectors.toList());
                }
                catch (IOException iOException) {
                    field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)\u2603, (Object)iOException);
                    HashMap hashMap = Maps.newHashMap();
                    \u26036.forEach((modelResourceLocation, blockState) -> {
                        Pair pair2 = (Pair)\u26037.get(blockState);
                        if (pair2 == null) {
                            field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)\u2603, modelResourceLocation);
                            pair2 = \u260310;
                        }
                        this.func_209593_a((ResourceLocation)modelResourceLocation, (IUnbakedModel)pair2.getFirst());
                        try {
                            ModelListWrapper modelListWrapper2 = (ModelListWrapper)((Supplier)pair2.getSecond()).get();
                            hashMap.computeIfAbsent(modelListWrapper2, modelListWrapper -> Sets.newIdentityHashSet()).add(blockState);
                        }
                        catch (Exception exception) {
                            field_177603_c.warn("Exception evaluating model definition: '{}'", modelResourceLocation, (Object)exception);
                        }
                    });
                    hashMap.forEach((modelListWrapper, set2) -> {
                        Set set2;
                        Iterator iterator = set2.iterator();
                        while (iterator.hasNext()) {
                            BlockState blockState = (BlockState)iterator.next();
                            if (blockState.func_185901_i() == BlockRenderType.MODEL) continue;
                            iterator.remove();
                            this.field_225367_M.put((Object)blockState, 0);
                        }
                        if (set2.size() > 1) {
                            this.func_225352_a((Iterable<BlockState>)set2);
                        }
                    });
                    return;
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Multipart multipart;
                    Pair pair = (Pair)iterator.next();
                    BlockModelDefinition \u260311 = (BlockModelDefinition)pair.getSecond();
                    IdentityHashMap \u260312 = Maps.newIdentityHashMap();
                    if (\u260311.func_188002_b()) {
                        multipart = \u260311.func_188001_c();
                        \u26035.forEach(arg_0 -> ModelBakery.func_229339_a_(\u260312, multipart, (List)\u26034, arg_0));
                    } else {
                        multipart = null;
                    }
                    \u260311.func_209578_a().forEach((arg_0, arg_1) -> ModelBakery.func_229329_a_(\u26035, \u26033, \u260312, (List)\u26034, multipart, \u260310, \u260311, \u2603, pair, arg_0, arg_1));
                    \u26037.putAll(\u260312);
                }
            }
            catch (BlockStateDefinitionException blockStateDefinitionException) {
                throw blockStateDefinitionException;
            }
            catch (Exception exception) {
                throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", \u2603, exception));
            }
            finally {
                HashMap hashMap = Maps.newHashMap();
                \u26036.forEach((modelResourceLocation, blockState) -> {
                    Pair pair2 = (Pair)\u26037.get(blockState);
                    if (pair2 == null) {
                        field_177603_c.warn("Exception loading blockstate definition: '{}' missing model for variant: '{}'", (Object)\u2603, modelResourceLocation);
                        pair2 = \u260310;
                    }
                    this.func_209593_a((ResourceLocation)modelResourceLocation, (IUnbakedModel)pair2.getFirst());
                    try {
                        ModelListWrapper modelListWrapper2 = (ModelListWrapper)((Supplier)pair2.getSecond()).get();
                        hashMap.computeIfAbsent(modelListWrapper2, modelListWrapper -> Sets.newIdentityHashSet()).add(blockState);
                    }
                    catch (Exception exception) {
                        field_177603_c.warn("Exception evaluating model definition: '{}'", modelResourceLocation, (Object)exception);
                    }
                });
                hashMap.forEach((modelListWrapper, set2) -> {
                    Set set2;
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        BlockState blockState = (BlockState)iterator.next();
                        if (blockState.func_185901_i() == BlockRenderType.MODEL) continue;
                        iterator.remove();
                        this.field_225367_M.put((Object)blockState, 0);
                    }
                    if (set2.size() > 1) {
                        this.func_225352_a((Iterable<BlockState>)set2);
                    }
                });
            }
        }
    }

    private void func_209593_a(ResourceLocation resourceLocation, IUnbakedModel iUnbakedModel) {
        this.field_217849_F.put(resourceLocation, iUnbakedModel);
        this.field_217848_D.addAll(iUnbakedModel.func_187965_e());
    }

    private void func_217843_a(ModelResourceLocation modelResourceLocation) {
        IUnbakedModel iUnbakedModel = this.func_209597_a(modelResourceLocation);
        this.field_217849_F.put(modelResourceLocation, iUnbakedModel);
        this.field_217851_H.put(modelResourceLocation, iUnbakedModel);
    }

    private void func_225352_a(Iterable<BlockState> iterable) {
        int n = this.field_225366_L++;
        iterable.forEach(blockState -> this.field_225367_M.put(blockState, n));
    }

    @Nullable
    public IBakedModel func_217845_a(ResourceLocation resourceLocation, IModelTransform iModelTransform) {
        Triple triple = Triple.of((Object)resourceLocation, (Object)iModelTransform.func_225615_b_(), (Object)iModelTransform.func_188049_c());
        if (this.field_217850_G.containsKey(triple)) {
            return this.field_217850_G.get(triple);
        }
        if (this.field_229322_z_ == null) {
            throw new IllegalStateException("bake called too early");
        }
        IUnbakedModel \u26032 = this.func_209597_a(resourceLocation);
        if (\u26032 instanceof BlockModel && ((BlockModel)(\u26033 = (BlockModel)\u26032)).func_178310_f() == field_177606_o) {
            return field_217854_z.func_209579_a(this.field_229322_z_::func_229151_a_, (BlockModel)\u26033).func_228813_a_(this, (BlockModel)\u26033, this.field_229322_z_::func_229151_a_, iModelTransform, resourceLocation, false);
        }
        Object \u26033 = \u26032.func_225613_a_(this, this.field_229322_z_::func_229151_a_, iModelTransform, resourceLocation);
        this.field_217850_G.put((Triple<ResourceLocation, TransformationMatrix, Boolean>)triple, (IBakedModel)\u26033);
        return \u26033;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockModel func_177594_c(ResourceLocation resourceLocation) throws IOException {
        String string;
        IResource \u26032;
        Reader \u26034;
        block8: {
            block7: {
                BlockModel blockModel;
                \u26034 = null;
                \u26032 = null;
                try {
                    string = resourceLocation.func_110623_a();
                    if (!"builtin/generated".equals(string)) break block7;
                    blockModel = field_177606_o;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(\u26034);
                    IOUtils.closeQuietly(\u26032);
                    throw throwable;
                }
                IOUtils.closeQuietly(\u26034);
                IOUtils.closeQuietly(\u26032);
                return blockModel;
            }
            if (!"builtin/entity".equals(string)) break block8;
            BlockModel blockModel = field_177616_r;
            IOUtils.closeQuietly(\u26034);
            IOUtils.closeQuietly(\u26032);
            return blockModel;
        }
        if (string.startsWith("builtin/")) {
            Object object = string.substring("builtin/".length());
            String \u26033 = field_177600_d.get(object);
            if (\u26033 == null) {
                throw new FileNotFoundException(resourceLocation.toString());
            }
            \u26034 = new StringReader(\u26033);
        } else {
            \u26032 = this.field_177598_f.func_199002_a(new ResourceLocation(resourceLocation.func_110624_b(), "models/" + resourceLocation.func_110623_a() + ".json"));
            \u26034 = new InputStreamReader(\u26032.func_199027_b(), StandardCharsets.UTF_8);
        }
        object = BlockModel.func_178307_a(\u26034);
        ((BlockModel)object).field_178317_b = resourceLocation.toString();
        Object object = object;
        IOUtils.closeQuietly((Reader)\u26034);
        IOUtils.closeQuietly((Closeable)\u26032);
        return object;
    }

    public Map<ResourceLocation, IBakedModel> func_217846_a() {
        return this.field_217852_I;
    }

    public Object2IntMap<BlockState> func_225354_b() {
        return this.field_225367_M;
    }

    private static /* synthetic */ void func_229329_a_(ImmutableList immutableList, StateContainer stateContainer, Map map, List list, Multipart multipart, Pair pair, BlockModelDefinition blockModelDefinition, ResourceLocation resourceLocation, Pair pair2, String string, VariantList variantList) {
        try {
            immutableList.stream().filter(ModelBakery.func_209605_a(stateContainer, string)).forEach(blockState -> {
                Pair pair2 = map.put(blockState, Pair.of((Object)variantList, () -> ModelListWrapper.func_225336_a(blockState, variantList, list)));
                if (pair2 != null && pair2.getFirst() != multipart) {
                    map.put(blockState, pair);
                    throw new RuntimeException("Overlapping definition with: " + (String)blockModelDefinition.func_209578_a().entrySet().stream().filter(entry -> entry.getValue() == pair2.getFirst()).findFirst().get().getKey());
                }
            });
        }
        catch (Exception exception) {
            field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)resourceLocation, pair2.getFirst(), (Object)string, (Object)exception.getMessage());
        }
    }

    private static /* synthetic */ void func_229339_a_(Map map, Multipart multipart, List list, BlockState blockState) {
        map.put(blockState, Pair.of((Object)multipart, () -> ModelListWrapper.func_225335_a(blockState, multipart, list)));
    }

    static class ModelListWrapper {
        private final List<IUnbakedModel> field_225339_a;
        private final List<Object> field_225340_b;

        public ModelListWrapper(List<IUnbakedModel> list, List<Object> list2) {
            this.field_225339_a = list;
            this.field_225340_b = list2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ModelListWrapper) {
                ModelListWrapper modelListWrapper = (ModelListWrapper)object;
                return Objects.equals(this.field_225339_a, modelListWrapper.field_225339_a) && Objects.equals(this.field_225340_b, modelListWrapper.field_225340_b);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.field_225339_a.hashCode() + this.field_225340_b.hashCode();
        }

        public static ModelListWrapper func_225335_a(BlockState blockState, Multipart multipart, Collection<Property<?>> collection) {
            StateContainer<Block, BlockState> stateContainer = blockState.func_177230_c().func_176194_O();
            List \u26032 = (List)multipart.func_188136_a().stream().filter(selector -> selector.func_188166_a(stateContainer).test(blockState)).map(Selector::func_188165_a).collect(ImmutableList.toImmutableList());
            List<Object> \u26033 = ModelListWrapper.func_225337_a(blockState, collection);
            return new ModelListWrapper(\u26032, \u26033);
        }

        public static ModelListWrapper func_225336_a(BlockState blockState, IUnbakedModel iUnbakedModel, Collection<Property<?>> collection) {
            List<Object> list = ModelListWrapper.func_225337_a(blockState, collection);
            return new ModelListWrapper((List<IUnbakedModel>)ImmutableList.of((Object)iUnbakedModel), list);
        }

        private static List<Object> func_225337_a(BlockState blockState, Collection<Property<?>> collection) {
            return (List)collection.stream().map(blockState::func_177229_b).collect(ImmutableList.toImmutableList());
        }
    }

    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String string) {
            super(string);
        }
    }
}

